require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require_relative '../base/base'
require_relative '../../helper/table'

class LandingCC < Base
  include PageObject

  def initialize(driver)
    super(driver)
  end

  #Landing Page for User with no ICN/DFN
  h2(:page_title,:css => "#main-content > div > div > h2:nth-child(1)")
  h2(:page_subtitle,:css => "#main-content > div > div > h2.error-header")
  div(:page_details_noICN,:css => "#main-content .vha-enrollment")
  div(:page_details_noDFN,:css => "#main-content .vha-register")
  a(:va_benefits_link,:css => ".error-header + p+p+ol+p .external-link")
  a(:learn_cc,:css => "#learn-cc")
  div(:learn_cc_text,:css => "body > div.ui-popup-container.ui-popup-active")
  button(:learn_cc_ok_btn,:css => "#learncc-ok-btn")
  a(:link_vet_choice,:css => "a[href='https://www.DOMAIN.EX/opa/choiceact/']")
  a(:facility_locator_link, :css => "a[href='https://www.DOMAIN.EX/directory/guide/division.asp?dnum=1']")

  #Confirmation Modal
  h3(:modal_title,:css => "#external-nav > div.ui-corner-top.ui-header.ui-bar-- > h3")

  #Confirmation Modal when clicking VA Choice link
  p(:modal_info,:css => "#external-nav > div.ui-content > p")
  p(:modal_content, :css => "#external-nav .ui-content>p")
  button(:modal_continue_btn, :css => '#external-nav-continue-btn')
  button(:modal_return_btn, :css => '#external-nav-return-btn')



endTT